
#include "Mesquite_all_headers.hpp"
#include <iostream>
#include <sstream>

using std::cout;
using std::cerr;
using std::endl;
using std::ostream;
using std::ostringstream;

using namespace MESQUITE_NS;


void bendBar( MeshImpl &mesh )
{
  MsqPrintError err(cerr);

  // get all vertices
  std::vector<Mesquite::Mesh::VertexHandle> all_vertices;
  mesh.get_all_vertices(all_vertices, err);
  if (err) std::cout << err << std::endl;
  int num_vertices = all_vertices.size();    

  // get all vertex coordinates
  std::vector<MsqVertex> all_coords(num_vertices);
  mesh.vertices_get_coordinates( arrptr(all_vertices), arrptr(all_coords), num_vertices, err);
  if (err) std::cout << err << std::endl;

  // get fixed flag
  std::vector<bool> fixed(num_vertices);
  mesh.vertices_get_fixed_flag( arrptr(all_vertices), fixed, num_vertices, err );

  //
  // loop over all vertices, if a vertex is fixed and its coordinates indicate it is on the bar
  // boundary, apply the bending transformation
  //
const double pi=4.0* atan(1.0);
double phi = 0.85*pi;

for(int i = 0; i < num_vertices; i++)
{
  double x=all_coords[i].x();
  double y=all_coords[i].y();
      
  if( fixed[i]== true && ( (fabs(y)<.05)&&(fabs(x)<.51 )))
  {
    double r=1.0/phi;
    double theta = 0.5*pi-x*phi;

    Vector3D newCoord(r*cos(theta),r*(sin(theta)-1.0)+y,0.0);
    mesh.vertex_set_coordinates(all_vertices[i],newCoord,err);
    if(err) cout<<err<<endl;
  }
}//end of loop over vertices

}
int main( int argc, char* argv[] )
{
  MsqPrintError err(cout);
    
  ostringstream meshfile,infile, outfile;

  meshfile<<"./bar_i.vtk";

  MeshImpl mesh;

  mesh.read_vtk( meshfile.str().c_str() , err);
  if( err) cout<< err<< endl;

  mesh.write_vtk("InitialMesh.vtk",err);
  if( err) cout<< err<< endl;
  
  bendBar( mesh );

  mesh.write_vtk("/g/g92/kim74/warpedmesh.vtk",err);
  if( err) cout<< err<< endl;
  
  
  return 0;
}
